/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.condition;

import dev.toma.gunsrpg.common.quests.QuestProperties;
import dev.toma.gunsrpg.common.quests.condition.AbstractQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestCondition;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.QuestConditionProviderType;
import dev.toma.gunsrpg.common.quests.trigger.ITriggerHandler;
import dev.toma.gunsrpg.common.quests.trigger.Trigger;
import dev.toma.gunsrpg.util.properties.IPropertyReader;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class UniqueMobKillsConditionProvider
extends AbstractQuestConditionProvider<ConditionTracker> {
    public UniqueMobKillsConditionProvider(QuestConditionProviderType<? extends UniqueMobKillsConditionProvider> type) {
        super(type);
    }

    public static UniqueMobKillsConditionProvider fromNbt(QuestConditionProviderType<UniqueMobKillsConditionProvider> type, CompoundNBT nbt) {
        return new UniqueMobKillsConditionProvider((QuestConditionProviderType<? extends UniqueMobKillsConditionProvider>)type);
    }

    @Override
    public ConditionTracker makeConditionInstance() {
        return new ConditionTracker(this);
    }

    final class ConditionTracker
    implements IQuestCondition,
    ITriggerHandler {
        private final Set<EntityType<?>> killedMobs = new HashSet();
        private final ITextComponent[] descriptors;

        public ConditionTracker(UniqueMobKillsConditionProvider provider) {
            this.descriptors = AbstractQuestConditionProvider.expandWithShortLocalizations(new ITextComponent[]{new TranslationTextComponent(provider.getLocalizationString())});
        }

        @Override
        public ITextComponent getDescriptor(boolean shortDesc) {
            return this.descriptors[shortDesc ? 1 : 0];
        }

        @Override
        public boolean isValid(PlayerEntity player, IPropertyReader reader) {
            Entity entity = (Entity)reader.getProperty(QuestProperties.ENTITY);
            if (entity instanceof MonsterEntity) {
                EntityType type = entity.func_200600_R();
                return !this.killedMobs.contains(type);
            }
            return false;
        }

        @Override
        public void handleTriggerSuccess(Trigger trigger, IPropertyReader reader) {
            Entity entity = (Entity)reader.getProperty(QuestProperties.ENTITY);
            EntityType type = entity.func_200600_R();
            this.killedMobs.add(type);
        }

        @Override
        public IQuestConditionProvider<?> getProviderType() {
            return UniqueMobKillsConditionProvider.this;
        }

        @Override
        public void saveData(CompoundNBT nbt) {
            ListNBT list = new ListNBT();
            this.killedMobs.stream().map(type -> StringNBT.func_229705_a_((String)type.getRegistryName().toString())).forEach(arg_0 -> list.add(arg_0));
            nbt.func_218657_a("killedMobs", (INBT)list);
        }

        @Override
        public void loadData(CompoundNBT nbt) {
            this.killedMobs.clear();
            ListNBT list = nbt.func_150295_c("killedMobs", 8);
            list.stream().map(inbt -> {
                ResourceLocation location = new ResourceLocation(inbt.func_150285_a_());
                return (EntityType)ForgeRegistries.ENTITIES.getValue(location);
            }).forEach(this.killedMobs::add);
        }
    }
}

